from earthdaily.earthone.compute import Function


def f(i):
    from compute_examples.basic import hello

    return hello(i)


print("creating function")
async_func = Function(
    f,
    name="my-compute-hello",
    image="python3.10",
    include_modules=["compute_examples"],
    requirements=["geopandas"],
    cpus=1,
    memory=2048,
    maximum_concurrency=1,
    timeout=600,
    retry_count=1,
)
async_func.save()

# invoke the function to create a job
print("submitting a job")
job = async_func(5)

print("waiting for the job to complete")
job.wait_for_completion()

print("job status:")
print(job.status())
print("job result:")
print(job.result())
print("job log:")
print(job.log())
