from earthdaily.earthone.compute import Function


def cython_fib(n):
    """Simple entrypoint wrapper function for executing func from cython module"""
    from compute_examples.cython_fibonacci import fib

    return fib(n)


print("creating function")
async_func = Function(
    cython_fib,
    name="my-compute-cython-fib",
    image="python3.8",
    image="python3.10",
    include_modules=["compute_examples.cython_fibonacci"],
    requirements=["cython==0.29.7"],
    cpus=1,
    memory=2048,
    maximum_concurrency=1,
    timeout=600,
    retry_count=1,
)
async_func.save()

# submit a job to the function
print("submitting a job")
job = async_func(10)

print("waiting for the job to complete")
job.wait_for_completion()

print("job status:")
print(job.status())
print("job result:")
print(job.result())
print("job log:")
print(job.log())
