import numpy as np
from earthdaily.earthone.compute import Function

print("creating function")
async_func = Function(
    "compute_examples.basic.generate_random_image",
    name="my-compute-random-image",
    image="python3.10",
    include_modules=["compute_examples"],
    requirements=[
        "geopandas",
    ],
    cpus=1,
    memory=2048,
    maximum_concurrency=20,
    timeout=600,
    retry_count=1,
)
async_func.save()

print("waiting for function to build")
async_func.wait_for_completion()

# submit 20 jobs to the function
print("submitting jobs")
jobs = async_func.map((i,) for i in range(20))

# wait for jobs, handling each as it completes
for job in async_func.as_completed(jobs):
    if job.status == JobStatus.SUCCESS:
        print(np.array(job.result()).shape)
    else:
        print(job.status)
        print(job.error_reason)
        print(job.log())
