import tensorflow as tf


# We define our TensorFlow task.
def gpu_tf_ex(n):
    # We explicitly tell TensorFlow to execute the subsequent operations on the GPU.
    with tf.device("/device:GPU:0"):
        a = tf.constant(
            list(range(1, 2 * (n + 1))),
            dtype=tf.float32,
            shape=[n - 1, n + 1],
            name="a",
        )
        b = tf.constant(
            list(range(1, 2 * (n + 1))),
            dtype=tf.float32,
            shape=[n + 1, n - 1],
            name="b",
        )
        c = tf.matmul(a, b)

    result = None

    # By setting allow_soft_placement to False, this task will fail if it can't
    # execute the above computation on a GPU.
    with tf.Session(config=tf.ConfigProto(allow_soft_placement=False)) as sess:
        result = sess.run(c)

    # return values MUST be JSON-serializable
    return result.tolist()
